[**Oklahoma NG911 Toolkit**](../README.html) | [***Prep***] | [Enhancement] | [Validation] | [MSAG] | [Comparison] | [Submission]

**Supplementary Documentation** | [Examples] | [Topology Rules] | [Change Log] | [Error Glossary]

# Prep Toolset

## Toolset Credits

* Riley Baird, Oklahoma Transportation Cabinet
* Emma Baker, Oklahoma Transportation Cabinet

##### Last Revised:

July 1, 2025

## Abstract

The *Prep* tools includes:

* **Assign `NGUID` Field** - A tool that creates a NENA unique `NGUID` field for objects in a non-Standard feature class.
* **Create Standard Geodatabase** - A tool that creates a new user-named Standard geodatabase with the correct schema in the specified folder location using a selected coordinate reference system. These tools should be run to ensure the feature classes and geodatabase that will be submitted are formatted with the correct domains and field names.
* **Field Map Feature Class** - A tool that creates field maps from user-specified feature class fields to Standard feature class fields with the correct schema including names, types, lengths, and domains.
* **Create Blank Standard Feature Class** - A tool that creates blank Standard feature classes in a Standard geodatabase.
* **Create Standard ESZ & ESB Feature Classes** - A tool that dissolves a ESB feature class to create Standard ESZ and ESB Feature Classes.


## Tools

### 0 - Assign `NGUID` Field

![Assign NGUID](img/Prep0_AssignNGUID.png)

* The tool creates a NENA unique `NGUID` for features in a feature class. The tool concatenates user-specified `URN`, `Local`, or `Agency` fields or reformats user-specified unique NGUID field for user-specified feature class. The feature class does **NOT** have to be Standards-compliant. The tool will create a new Standard-compliant `NGUID` field and calculate it using user-specified parameters. The user-specified assign method will determine how the new field is concatenated. Certain assign methods require certain fields.

#### Usage

1. Select the Standard feature class name.
2. Select feature class to assign `NGUID`.
3. Select assign method to specify which `NGUID` creation method to use.
    * 'NGUID' - Requires user-specified `NGUID` field. Method required for a format change.
    * 'LOCAL' - Requires `Local` field.
    * 'SEQUENTIAL' - Uses a sequential count for the Local portion of the `NGUID` field
4. Optional switch for Old format (`@`) to New format (`:`).
5. Optional switch to delete old `NGUID` field. Since the tool will create a new `NGUID` field to ensure that the Standard schema is followed, the user may specify whether to keep or delete the old `NGUID` field.
6. Optional name for the old `NGUID` field that will be used if user selects to not delete the old field (usage 5).
7. Field table containing field options for the `NGUID`, `Local`, and `Agency` fields. The filter list is based on the user-specified feature class (usage 2).
8. Execute the tool.

### 1 - Create Standard GDB

![Create GDB Tool](img/Prep1_CreateGDB.png)

* The tool creates a Standard geodatabase in the specified folder location using a selected coordinate reference system. None, some, or all feature classes may be provided, but they must follow the Standard schema. Blank Standard feature classes can also be created in the Standard geodatasbase.

#### Usage

1. Select folder location.
2. Select geodatabase name (without '.gdb'.).
3. Select Spatial Reference option. If '--USER SPECIFIED--' is selected, the user will need to select a Spatial Reference manually.
4. Select Standard feature classes or the option to create blank feature classes. If nothing is provided, nothing will be created.
5. Execute the tool.

### 2 - Field Map Feature Class

![Field Map Tool](img/Prep2_FieldMap.png)

* A tool creates field maps from user-specified feature class fields to Standard feature class fields with the correct schema including names, types, lengths, and domains. An empty Standard feature class is first created and then the Standard-compliant fields are added. Field mapping between the user fields and the Standard fields is performed. The values in the user fields are assessed and modified if necessary based on the Standards.

#### Usage

1. Select Standard geodatabase.
2. Select Standard feature class name.
3. Select user-specified feature class.
4. Select fields to be mapped. If no field is specified, the field will remain blank.
5. Execute the tool.

### 3 - Create Blank Standard Feature Class

![Create Blank FC Tool](img/Prep3_CreateBlankFC.png)

* A tool that creates blank Standard feature classes in a Standard geodatabase.

#### Usage

1. Select Standard geodatabase.
2. Select the Standard feature class names to create blank.
3. Execute the tool.

### 4 - Create Standard ESZ & ESB Feature Classes

![Split ESZ Tool](img/Prep4_CreateESZESB.png)

* This tool takes dissolves an ESZ feature class and creates the Standard ESZ_BOUNDARY, ESB_EMS_BOUNDARY, ESB_LAW_BOUNDARY, and ESB_FIRE_BOUNDARY feature classes in the Standard geodatabase.

#### Usage

1. Select ESZ feature class to dissolve.
    * Must have, at minimum, fields that map to `ESZ`, `EMS`, `FIRE`, and `LAW`.
2. Select Standard geodatabase.
3. If desired, select the option to assign sequential NGUIDs to ESB feature classes.
    * This will have no effect on the output ESZ feature class, only the output ESB feature classes.
4. Select NGUID assignment method for `NGUID_ESZ`.
    * This will not have any effect on the output ESB feature classes, only the output ESZ feature class.
    * Depending on the method, fields that map to one or more of `NGUID_ESZ`, `Agency_ID`, and/or `Local_ID`.
    * If the "NGUID" method is selected, an option will be available to convert existing v2.2 NGUIDs to v3 NGUIDs.
5. If desired, select the option to copy the ESB fields to the `DsplayName` fields of the respective feature classes.
    * This will have no effect on the output ESZ feature class, only the output ESB feature classes.
    * For example the source field that is set to map to `EMS` will be mapped to the `DsplayName` field of ESB_EMS_BOUNDARY.
6. Select the fields to map.
7. Execute the tool.

## Support Contact

For issues or questions, please contact through email Riley Baird at <rbaird@odot.org> or Emma Baker at <ebaker@odot.org> with the Oklahoma Transportation Cabinet, and please include in the email which script you were running, any error messages, and a zipped copy of your geodatabase. Change the file extension from `zip` to `piz` so it gets through the email server. If there are further data transfer issues, contact Emma or Riley to make alternative data transfer arrangements.

## Disclaimer

The Oklahoma NG9-1-1 GIS Toolbox is provided by the Oklahoma Geographic Information (GI) Council, Oklahoma 9-1-1 Management Authority, Oklahoma Department of Transportation (ODOT), Oklahoma Office of Geographic Information (OGI) , and associated contributors "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed.  In no event shall the Oklahoma GI Council, Oklahoma 9-1-1 Management Authority, ODOT, OGI, or associated contributors be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.

<!-- External Doc links -->
[Prep]: Prep.html
[Adjustment]: Adjustment.html
[Comparison]: Comparison.html
[Enhancement]: Enhancement.html
[MSAG]: MSAG.html
[Submission]: Submission.html
[Validation]: Validation.html
[Topology Rules]: Topology.html
[Change Log]: ../ChangeLog.html
[Error Glossary]: ErrorGlossary.html
[Examples]: Examples.html
[Generate Fishbone Analysis]: FishboneAddressVerification.html